-- Medit Functions Script
-- meditUtilities Structure
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/* History

Feb  2005 -  split the functions from the MeditUtilities into this script to make them re-usable
June 2006 -  added functions for the mrArchMtl templates 

NOTE TO LOCALIZATION

Nothing should be localized in this script

*/

struct meditUtilities (


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn getDefaultsFile =
(
	defaultsFolder = getDir #defaults
	defaultsFile = defaultsFolder + #'\\CurrentDefaults.INI' as string
	if (getFiles defaultsFile).count == 0 do
		defaultsFile = defaultsFolder + #'\\FactoryDefaults\\CurrentDefaults.INI' as string
	if (getFiles defaultsFile).count == 0 then 
		undefined 
	else 
		defaultsFile
),
-- end getDefaultsFile
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn getDefaultLibraryFile =
(
	defaultsFolder = getDir #defaults
	defaultLibFile = defaultsFolder + #'\\medit.mat' as string
	if (getFiles defaultLibFile).count == 0 do
		defaultLibFile = defaultsFolder + #'\\FactoryDefaults\\medit.mat' as string
	if (getFiles defaultLibFile).count == 0 then 
		undefined 
	else 
		defaultLibFile
),
-- end getDefaultLibraryFile
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn getDefaultMaterial defaultsFileStr =
(
-- this is obsolete: still maybe used.
-- return material created from the class of the first element in the default library
-- parameter is not uded.
	defaultMtl = StandardMaterial

	defaultMtlLibFile = meditUtilities.getDefaultLibraryFile()
	if defaultMtlLibFile != undefined do
	(
		defaultMtlLib = loadTempMaterialLibrary defaultMtlLibFile
		if defaultMtlLib.count >= 1 do
			defaultMtl = (classof defaultMtlLib[1])()
	)

	defaultMtl
),
-- end getDefaultMaterial
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn isMaterialInUse mtl =
(
	local foundSceneRef = false
	if superClassof mtl == material or superClassof mtl == textureMap do
	(
		local deps = refs.dependents mtl
		for i in deps while not foundSceneRef do
		(
			local c = classof i
			local sc = superclassof i
			local sid = i.superclassid
			-- exclude scene root, scene mtl lib, medit, materials, texturemaps, and texture map containers (used by std mtl to hold texmaps)
			foundSceneRef = c != Scene and c != MtlBaseLib and c != Material_Editor and sc != Material and sc != TextureMap and sid != 4224
		)
	)
	foundSceneRef 	
),
-- end isMaterialInUse
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

-- Set_mrArchTemplate_ActiveMaterial_FromMaterialInMatlib
-- Get a Material Name and loads each properties into the global mrArchTemplate_ActiveMaterial
-- Used by the mrArchMaterial templates drop down
-- material name defined in the /plugcfg/mrArchMaterial.ini file


fn Set_mrArchTemplate_ActiveMaterial_FromMaterialInMatlib mrArchTemplate_ActiveMaterial strMtlName =
(
	local matFromLib	
	matFromLib = (loadTempMaterialLibrary ((getdir #maxroot) + "\\materiallibraries\\mrArch_DesignTemplates.mat"))[strMtlName]

	undo on
	(
		for i in getPropNames(matFromLib) do
		(
			local j = (getProperty matFromLib i)
			try (
				SetProperty mrArchTemplate_ActiveMaterial i j
			)
			catch (
				-- Do nothing, normal for a read-only property
			)
		)
	)
	
),
--end Set_mrArchTemplate_ActiveMaterial_FromMaterialInMatlib
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

-- Set_PhysicalTemplate_ActiveMaterial_FromMaterialInMatlib
-- Get a Material Name and loads each properties into the passed material
-- Used by the Physical Material templates drop down
-- material name defined in the /plugcfg/PhysicalMaterial.ini file

fn Set_PhysicalTemplate_ActiveMaterial_FromMaterialInMatlib mtl strMtlName =
(
	local matFromLib	
	matFromLib = (loadTempMaterialLibrary ((getdir #maxroot) + "\\materiallibraries\\PhysicalMaterialTemplates.mat"))[strMtlName]

	undo on
	(
		for i in getPropNames(matFromLib) do
		(
			local j = (getProperty matFromLib i)
			try (
				SetProperty mtl i j
			)
			catch (
				-- Do nothing, normal for a read-only property
			)
		)
	)
	
)--end Set_PhysicalTemplate_ActiveMaterial_FromMaterialInMatlib
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||




) -- end struct

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQDFH5EAFvUxXCrOG75YZcZT8iIamLy/rABH
-- GYUoK06+3SdEKN4YlGsF99wztHQTlnF5bVL/OL2buCfPxALzU9Ndqk+YNMUYrZKH
-- G9MKrjliegSNLszCM4TOpbFn6SECg6vvjZcDLM2yTM9zhRls9glu5RJjvhcDWWMS
-- ebS/OVTeF6FDpNhkGSwJLJpYf2e+eFpwtk+lA5XWe92zpnWeVqL6QW9vV10BGdKY
-- zanRxl3PMjn/Wmo+hGYnnBSgQH8/PryRHq4/8NjufTP4XcAlvW31uky2sXuLkG1L
-- MpokADF8A2mpPGqai3inGllnGIZ6/A0zM8li8mqOUQCmAW5e9dGL
-- -----END-SIGNATURE-----